const templateFile = await fetch("component/Navigation/template.html");
const template = await templateFile.text();

const templateLiFile = await fetch("component/Navigation/templateLi.html");
const templateLi = await templateLiFile.text();

let Navigation = {}; 

Navigation.format = function(data, css=""){
    let html = template;
    html = html.replace("{{cssClass}}", css );
    html = html.replace("{{title}}", data.title );

     let menuHTML = "";
    for (let menu of data.menus) {
        let li = templateLi;
        li = li.replace("{{name}}", menu.name );
        li = li.replace("{{link}}", menu.link );
        menuHTML += li;
    }

    html = html.replace("{{menuItems}}", menuHTML );
    return html;
}

Navigation.render = function( where, data, css="" ){
    let node = document.querySelector(where);
    node.innerHTML += Navigation.format( data, css );
}

export { Navigation };